/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics;

import com.mojang.blaze3d.systems.RenderSystem;
import icyllis.modernui.graphics.Paint;
import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.graphics.math.Icon;
import icyllis.modernui.graphics.math.TextAlign;
import icyllis.modernui.graphics.shader.ShaderProgram;
import icyllis.modernui.graphics.shader.program.ArcProgram;
import icyllis.modernui.graphics.shader.program.CircleProgram;
import icyllis.modernui.graphics.shader.program.RectProgram;
import icyllis.modernui.graphics.shader.program.RoundRectProgram;
import icyllis.modernui.graphics.textmc.TextLayoutProcessor;
import icyllis.modernui.graphics.textmc.pipeline.TextRenderNode;
import icyllis.modernui.platform.RenderCore;
import icyllis.modernui.view.View;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.Style;
import org.lwjgl.opengl.GL43;

public class Canvas {
    private static Canvas instance;
    private final MainWindow mMainWindow;
    private final ItemRenderer mItemRenderer;
    private final TextLayoutProcessor mFontEngine = TextLayoutProcessor.getInstance();
    @Deprecated
    private final BufferBuilder mBufferBuilder = Tessellator.func_178181_a().func_178180_c();
    @Deprecated
    private int r = 255;
    @Deprecated
    private int g = 255;
    @Deprecated
    private int b = 255;
    @Deprecated
    private int a = 255;
    @Deprecated
    private double z = 0.0;
    @Deprecated
    private long drawingTime = 0L;
    @Deprecated
    private float alignFactor;
    private static boolean lineAA;

    private Canvas(@Nullable Minecraft minecraft) {
        this.alignFactor = TextAlign.LEFT.offsetFactor;
        if (minecraft != null) {
            this.mMainWindow = minecraft.func_228018_at_();
            this.mItemRenderer = minecraft.func_175599_af();
        } else {
            this.mMainWindow = null;
            this.mItemRenderer = null;
        }
    }

    public static Canvas getInstance() {
        RenderCore.ensureRenderThread();
        if (instance == null) {
            instance = new Canvas(Minecraft.func_71410_x());
        }
        return instance;
    }

    public void setRGBA(int r, int g2, int b, int a) {
        this.r = r;
        this.g = g2;
        this.b = b;
        this.a = a;
    }

    @Deprecated
    public void setRGB(int r, int g2, int b) {
        this.r = r;
        this.g = g2;
        this.b = b;
    }

    @Deprecated
    public void setColor(int color) {
        this.a = color >> 24 & 0xFF;
        this.r = color >> 16 & 0xFF;
        this.g = color >> 8 & 0xFF;
        this.b = color & 0xFF;
    }

    public void setAlpha(int a) {
        this.a = a;
    }

    public void resetColor() {
        this.r = 255;
        this.g = 255;
        this.b = 255;
        this.a = 255;
    }

    @Deprecated
    public long getDrawingTime() {
        return this.drawingTime;
    }

    @Deprecated
    public void setDrawingTime(long drawingTime) {
        this.drawingTime = drawingTime;
    }

    public void setLineAntiAliasing(boolean aa) {
        if (aa) {
            if (!lineAA) {
                GL43.glEnable((int)2848);
                GL43.glHint((int)3154, (int)4354);
                lineAA = true;
            }
        } else if (lineAA) {
            GL43.glDisable((int)2848);
            lineAA = false;
        }
    }

    public void setLineWidth(float width) {
        RenderSystem.lineWidth((float)width);
    }

    @Deprecated
    public void setZ(double z) {
        this.z = z;
    }

    @Deprecated
    public void setTextAlign(@Nonnull TextAlign align) {
        this.alignFactor = align.offsetFactor;
    }

    @Deprecated
    public float drawText(String text, float x, float y) {
        if (text == null || text.isEmpty()) {
            return 0.0f;
        }
        TextRenderNode node = this.mFontEngine.lookupVanillaNode(text, Style.field_240709_b_);
        if (this.alignFactor > 0.0f) {
            x -= node.advance * this.alignFactor;
        }
        return node.drawText(this.mBufferBuilder, text, x, y, this.r, this.g, this.b, this.a);
    }

    public void drawArc(float centerX, float centerY, float radius, float startAngle, float sweepAngle, @Nonnull Paint paint) {
        if (sweepAngle == 0.0f || radius <= 0.0f) {
            return;
        }
        if (sweepAngle < 0.0f) {
            sweepAngle = sweepAngle % 360.0f + 360.0f;
        }
        switch (paint.getStyle()) {
            case FILL: {
                this.fillArc(centerX, centerY, radius, startAngle, sweepAngle, paint);
                return;
            }
            case FILL_AND_STROKE: {
                this.fillArc(centerX, centerY, radius, startAngle, sweepAngle, paint);
            }
            case STROKE: {
                this.strokeArc(centerX, centerY, radius, startAngle, sweepAngle, paint);
            }
        }
    }

    protected void fillArc(float cx, float cy, float radius, float startAngle, float sweepAngle, @Nonnull Paint paint) {
        if (sweepAngle >= 360.0f) {
            this.fillCircle(cx, cy, radius, paint);
        } else {
            ArcProgram.Fill program = ArcProgram.fill();
            program.use();
            if ((startAngle < 0.0f || startAngle >= 360.0f) && (startAngle %= 360.0f) < 0.0f) {
                startAngle += 360.0f;
            }
            float middle = startAngle + sweepAngle * 0.5f;
            program.setCenter(cx, cy);
            program.setAngle(middle, sweepAngle);
            program.setRadius(radius, Math.min(radius, paint.getFeatherRadius()));
            this.upload(cx - radius, cy - radius, cx + radius, cy + radius, paint.getColor());
            ShaderProgram.stop();
        }
    }

    protected void strokeArc(float cx, float cy, float radius, float startAngle, float sweepAngle, @Nonnull Paint paint) {
        if (sweepAngle >= 360.0f) {
            this.strokeCircle(cx, cy, radius, paint);
        } else {
            ArcProgram.Stroke program = ArcProgram.stroke();
            program.use();
            if ((startAngle < 0.0f || startAngle >= 360.0f) && (startAngle %= 360.0f) < 0.0f) {
                startAngle += 360.0f;
            }
            float middle = startAngle + sweepAngle * 0.5f;
            program.setCenter(cx, cy);
            program.setAngle(middle, sweepAngle);
            float thickness = Math.min(paint.getStrokeWidth() * 0.5f, radius);
            program.setRadius(radius, Math.min(thickness, paint.getFeatherRadius()), thickness);
            float outer = radius + thickness;
            this.upload(cx - outer, cy - outer, cx + outer, cy + outer, paint.getColor());
            ShaderProgram.stop();
        }
    }

    public void drawRect(float left, float top, float right, float bottom, @Nonnull Paint paint) {
        if (left >= right || bottom <= top) {
            return;
        }
        switch (paint.getStyle()) {
            case FILL: {
                this.fillRect(left, top, right, bottom, paint);
                return;
            }
            case STROKE: {
                return;
            }
        }
        this.fillRect(left, top, right, bottom, paint);
    }

    protected void fillRect(float left, float top, float right, float bottom, @Nonnull Paint paint) {
        if (paint.getFeatherRadius() > 0.0f) {
            RectProgram.Feathered program = RectProgram.feathered();
            program.use();
            float t = Math.min(Math.min(right - left, right - bottom), paint.getFeatherRadius());
            program.setThickness(t);
            program.setInnerRect(left + t, top + t, right - t, bottom - t);
        } else {
            RectProgram.fill().use();
        }
        this.upload(left, top, right, bottom, paint.getColor());
        ShaderProgram.stop();
    }

    @Deprecated
    public void drawRectOutline(float left, float top, float right, float bottom, float thickness) {
        RenderSystem.disableTexture();
        int r = this.r;
        int g2 = this.g;
        int b = this.b;
        int a = this.a;
        double z = this.z;
        this.mBufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        this.mBufferBuilder.func_225582_a_((double)(left - thickness), (double)top, z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)right, (double)top, z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)right, (double)(top - thickness), z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)(left - thickness), (double)(top - thickness), z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)this.mBufferBuilder);
        this.mBufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        this.mBufferBuilder.func_225582_a_((double)right, (double)bottom, z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)(right + thickness), (double)bottom, z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)(right + thickness), (double)(top - thickness), z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)right, (double)(top - thickness), z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)this.mBufferBuilder);
        this.mBufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        this.mBufferBuilder.func_225582_a_((double)left, (double)(bottom + thickness), z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)(right + thickness), (double)(bottom + thickness), z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)(right + thickness), (double)bottom, z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)left, (double)bottom, z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)this.mBufferBuilder);
        this.mBufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        this.mBufferBuilder.func_225582_a_((double)(left - thickness), (double)(bottom + thickness), z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)left, (double)(bottom + thickness), z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)left, (double)top, z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)(left - thickness), (double)top, z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)this.mBufferBuilder);
    }

    @Deprecated
    public void drawOctagonRectFrame(float left, float top, float right, float bottom, float bevel) {
        RenderSystem.disableTexture();
        int r = this.r;
        int g2 = this.g;
        int b = this.b;
        int a = this.a;
        double z = this.z;
        this.mBufferBuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        this.mBufferBuilder.func_225582_a_((double)left, (double)(bottom - bevel), z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)(left + bevel), (double)bottom, z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)(right - bevel), (double)bottom, z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)right, (double)(bottom - bevel), z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)right, (double)(top + bevel), z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)(right - bevel), (double)top, z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)(left + bevel), (double)top, z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)left, (double)(top + bevel), z).func_225586_a_(r, g2, b, a).func_181675_d();
        this.mBufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)this.mBufferBuilder);
    }

    @Deprecated
    public void drawRectLines(float left, float top, float right, float bottom) {
        RenderSystem.disableTexture();
        this.mBufferBuilder.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        this.mBufferBuilder.func_225582_a_((double)left, (double)bottom, this.z).func_225586_a_(this.r, this.g, this.b, this.a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)right, (double)bottom, this.z).func_225586_a_(this.r, this.g, this.b, this.a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)right, (double)top, this.z).func_225586_a_(this.r, this.g, this.b, this.a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)left, (double)top, this.z).func_225586_a_(this.r, this.g, this.b, this.a).func_181675_d();
        this.mBufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)this.mBufferBuilder);
    }

    public void drawCircle(float centerX, float centerY, float radius, @Nonnull Paint paint) {
        if (radius <= 0.0f) {
            return;
        }
        switch (paint.getStyle()) {
            case FILL: {
                this.fillCircle(centerX, centerY, radius, paint);
                return;
            }
            case FILL_AND_STROKE: {
                this.fillCircle(centerX, centerY, radius, paint);
            }
            case STROKE: {
                this.strokeCircle(centerX, centerY, radius, paint);
            }
        }
    }

    protected void fillCircle(float cx, float cy, float r, @Nonnull Paint paint) {
        CircleProgram.Fill program = CircleProgram.fill();
        program.use();
        program.setRadius(r, Math.min(r, paint.getFeatherRadius()));
        program.setCenter(cx, cy);
        this.upload(cx - r, cy - r, cx + r, cy + r, paint.getColor());
        ShaderProgram.stop();
    }

    protected void strokeCircle(float cx, float cy, float r, @Nonnull Paint paint) {
        CircleProgram.Stroke program = CircleProgram.stroke();
        program.use();
        float thickness = Math.min(paint.getStrokeWidth() * 0.5f, r);
        float outer = r + thickness;
        program.setRadius(r - thickness, outer, Math.min(thickness, paint.getFeatherRadius()));
        program.setCenter(cx, cy);
        this.upload(cx - outer, cy - outer, cx + outer, cy + outer, paint.getColor());
        ShaderProgram.stop();
    }

    public void drawLine(float startX, float startY, float stopX, float stopY) {
        RenderSystem.disableTexture();
        this.mBufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        this.mBufferBuilder.func_225582_a_((double)startX, (double)startY, this.z).func_225586_a_(this.r, this.g, this.b, this.a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)stopX, (double)stopY, this.z).func_225586_a_(this.r, this.g, this.b, this.a).func_181675_d();
        this.mBufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)this.mBufferBuilder);
    }

    public void drawRoundRect(float left, float top, float right, float bottom, float radius, @Nonnull Paint paint) {
        radius = Math.max(0.0f, radius);
        switch (paint.getStyle()) {
            case FILL: {
                this.fillRoundRect(left, top, right, bottom, radius, paint);
                return;
            }
            case FILL_AND_STROKE: {
                this.fillRoundRect(left, top, right, bottom, radius, paint);
            }
            case STROKE: {
                this.strokeRoundRect(left, top, right, bottom, radius, paint);
            }
        }
    }

    protected void fillRoundRect(float left, float top, float right, float bottom, float r, @Nonnull Paint paint) {
        RoundRectProgram.Fill program = RoundRectProgram.fill();
        program.use();
        program.setRadius(r, Math.min(r, paint.getFeatherRadius()));
        program.setInnerRect(left + r, top + r, right - r, bottom - r);
        this.upload(left, top, right, bottom, paint.getColor());
        ShaderProgram.stop();
    }

    protected void strokeRoundRect(float left, float top, float right, float bottom, float r, @Nonnull Paint paint) {
        RoundRectProgram.Stroke program = RoundRectProgram.stroke();
        program.use();
        float thickness = Math.min(paint.getStrokeWidth() * 0.5f, r);
        program.setRadius(r, Math.min(thickness, paint.getFeatherRadius()), thickness);
        program.setInnerRect(left + r, top + r, right - r, bottom - r);
        this.upload(left - r, top - r, right + r, bottom + r, paint.getColor());
        ShaderProgram.stop();
    }

    @Deprecated
    protected void upload(float left, float top, float right, float bottom, int color) {
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        int a = color >>> 24;
        int r = color >> 16 & 0xFF;
        int g2 = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        builder.func_225582_a_((double)left, (double)bottom, 0.0).func_225586_a_(r, g2, b, a).func_181675_d();
        builder.func_225582_a_((double)right, (double)bottom, 0.0).func_225586_a_(r, g2, b, a).func_181675_d();
        builder.func_225582_a_((double)right, (double)top, 0.0).func_225586_a_(r, g2, b, a).func_181675_d();
        builder.func_225582_a_((double)left, (double)top, 0.0).func_225586_a_(r, g2, b, a).func_181675_d();
        builder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)builder);
    }

    @Deprecated
    public void drawRoundedFrameT1(float left, float top, float right, float bottom, float radius) {
        RoundRectProgram.Stroke program = RoundRectProgram.stroke();
        program.use();
        program.setRadius(radius, 1.0f, 1.0f);
        program.setInnerRect(left + radius, top + radius, right - radius, bottom - radius);
        this.mBufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        this.mBufferBuilder.func_225582_a_((double)left, (double)bottom, this.z).func_225586_a_(170, 220, 240, this.a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)right, (double)bottom, this.z).func_225586_a_(201, 200, 232, this.a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)right, (double)top, this.z).func_225586_a_(232, 180, 223, this.a).func_181675_d();
        this.mBufferBuilder.func_225582_a_((double)left, (double)top, this.z).func_225586_a_(201, 200, 232, this.a).func_181675_d();
        this.mBufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)this.mBufferBuilder);
        ShaderProgram.stop();
    }

    public void drawRoundImage(@Nonnull Icon icon, float left, float top, float right, float bottom, float radius, @Nonnull Paint paint) {
        RoundRectProgram.FillTex program = RoundRectProgram.fillTex();
        program.use();
        program.setRadius(radius, Math.min(radius, paint.getFeatherRadius()));
        program.setInnerRect(left + radius, top + radius, right - radius, bottom - radius);
        RenderSystem.activeTexture((int)33984);
        icon.bindTexture();
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        int color = paint.getColor();
        int a = color >>> 24;
        int r = color >> 16 & 0xFF;
        int g2 = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        builder.func_225582_a_((double)left, (double)bottom, 0.0).func_225586_a_(r, g2, b, a).func_225583_a_(icon.getLeft(), icon.getBottom()).func_181675_d();
        builder.func_225582_a_((double)right, (double)bottom, 0.0).func_225586_a_(r, g2, b, a).func_225583_a_(icon.getRight(), icon.getBottom()).func_181675_d();
        builder.func_225582_a_((double)right, (double)top, 0.0).func_225586_a_(r, g2, b, a).func_225583_a_(icon.getRight(), icon.getTop()).func_181675_d();
        builder.func_225582_a_((double)left, (double)top, 0.0).func_225586_a_(r, g2, b, a).func_225583_a_(icon.getLeft(), icon.getTop()).func_181675_d();
        builder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)builder);
        ShaderProgram.stop();
    }

    public void drawItem(@Nonnull Item item, float x, float y) {
        this.mItemRenderer.func_175042_a(item.func_190903_i(), (int)x, (int)y);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public void drawItemStack(@Nonnull ItemStack stack, float x, float y) {
        this.mItemRenderer.func_175042_a(stack, (int)x, (int)y);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    public void drawItemStackWithOverlays(@Nonnull ItemStack stack, float x, float y) {
        this.mItemRenderer.func_175042_a(stack, (int)x, (int)y);
        this.mItemRenderer.func_175030_a(Minecraft.func_71410_x().field_71466_p, stack, (int)x, (int)y);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    @Deprecated
    public void moveTo(@Nonnull View view) {
    }

    @Deprecated
    public void moveTo(@Nonnull Drawable drawable) {
    }

    @Deprecated
    public void moveToZero() {
    }

    public void save() {
        RenderSystem.pushMatrix();
    }

    public void restore() {
        RenderSystem.popMatrix();
    }

    public void translate(float dx, float dy) {
        RenderSystem.translatef((float)dx, (float)dy, (float)0.0f);
    }

    public void scale(float sx, float sy) {
        RenderSystem.scalef((float)sx, (float)sy, (float)1.0f);
    }

    public void scale(float sx, float sy, float px, float py) {
        RenderSystem.scalef((float)sx, (float)sy, (float)1.0f);
        float dx = sx < 1.0f ? 1.0f / sx - 1.0f : sx - 1.0f;
        float dy = sy < 1.0f ? 1.0f / sy - 1.0f : sy - 1.0f;
        RenderSystem.translatef((float)(dx *= px), (float)(dy *= py), (float)0.0f);
    }

    public void clipVertical(@Nonnull View view) {
        GL43.glEnable((int)3089);
        GL43.glScissor((int)0, (int)(this.mMainWindow.func_198091_l() - view.getBottom()), (int)this.mMainWindow.func_198109_k(), (int)view.getHeight());
    }

    public void clipStart(float x, float y, float width, float height) {
        double scale = this.mMainWindow.func_198100_s();
        GL43.glEnable((int)3089);
        GL43.glScissor((int)((int)((double)x * scale)), (int)((int)((double)this.mMainWindow.func_198091_l() - (double)(y + height) * scale)), (int)((int)((double)width * scale)), (int)((int)((double)height * scale)));
    }

    public void clipEnd() {
        GL43.glDisable((int)3089);
    }

    static {
        lineAA = false;
    }
}

